<?php
declare(strict_types=1);
@ini_set('display_errors','0');
@error_reporting(0);

require __DIR__ . '/config.php';
require __DIR__ . '/lib/functions.php';

cors_and_preflight();

$type     = $_GET['type'] ?? 'textnow';
$order_id = trim((string)($_GET['order_id'] ?? ''));
$quantity = (int)($_GET['quantity'] ?? 1);
$debug    = isset($_GET['debug']);

if (!isset(COLLECTIONS[$type])) json_out(array('error'=>'invalid_type'), 400);
if ($order_id === '' || $quantity < 1) json_out(array('error'=>'missing_order_or_quantity'), 400);

// check key per-type
require_key($type);

$collectionId = COLLECTIONS[$type];

$ordersPath = storage_path('orders.json');
$orders = read_json_file($ordersPath) ?: array();

// idempotent
if (isset($orders[$order_id]) && is_array($orders[$order_id])) json_out($orders[$order_id]);

function spt_buy(string $collectionId, int $quantity, string $accept = 'json'): array {
  $url = sprintf(
    'https://api.sptmail.com/api/mails/buy?apiKey=%s&amount=%d&collection=%s&acceptType=%s',
    urlencode(SPT_KEY), $quantity, urlencode($collectionId), $accept
  );
  $ctype = ''; $raw = ''; $json = null;

  if (function_exists('curl_init')) {
    $ch = curl_init($url);
    curl_setopt_array($ch, array(
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_TIMEOUT        => 25,
      CURLOPT_SSL_VERIFYPEER => false,
      CURLOPT_SSL_VERIFYHOST => 0,
      CURLOPT_HTTPHEADER     => array('Accept: application/json'),
      CURLOPT_USERAGENT      => 'Taphoammo-Proxy/3.0',
      CURLOPT_IPRESOLVE      => CURL_IPRESOLVE_V4,
    ));
    $raw   = (string) curl_exec($ch);
    $ctype = curl_getinfo($ch, CURLINFO_CONTENT_TYPE) ?: '';
    curl_close($ch);
  } else {
    $raw = (string) @file_get_contents($url);
  }

  if ($raw !== '') {
    $tmp = json_decode($raw, true);
    if (is_array($tmp)) $json = $tmp;
  }
  return array('url'=>$url, 'ctype'=>$ctype, 'raw'=>$raw, 'json'=>$json);
}

function parse_accounts($payload): array {
  $out = array();

  // A) Expected: {"gmails":[{"username":"...","password":"..."}], "success":true}
  if (is_array($payload) && isset($payload['gmails']) && is_array($payload['gmails'])) {
    foreach ($payload['gmails'] as $row) {
      $u = isset($row['username']) ? $row['username'] : '';
      $p = isset($row['password']) ? $row['password'] : (isset($row['pass']) ? $row['pass'] : '');
      if ($u !== '' && $p !== '') $out[] = array('product' => $u.'|'.$p);
    }
    if ($out) return $out;
  }

  // B) Other common JSON variants
  if (is_array($payload)) {
    $keys = array('mails','data','items','accounts');
    foreach ($keys as $k) {
      if (isset($payload[$k]) && is_array($payload[$k])) {
        // objects
        if (isset($payload[$k][0]) && is_array($payload[$k][0]) && isset($payload[$k][0]['username'])) {
          foreach ($payload[$k] as $row) {
            $u = isset($row['username']) ? $row['username'] : '';
            $p = isset($row['password']) ? $row['password'] : (isset($row['pass']) ? $row['pass'] : '');
            if ($u !== '' && $p !== '') $out[] = array('product' => $u.'|'.$p);
          }
          if ($out) return $out;
        }
        // strings
        if (isset($payload[$k][0]) && is_string($payload[$k][0])) {
          foreach ($payload[$k] as $ln) {
            $ln = trim((string)$ln);
            if ($ln === '') continue;
            $ln = str_replace(':','|',$ln);
            $ln = preg_replace('/\s+/', '', $ln);
            $parts = explode('|',$ln);
            if (count($parts) >= 2) $out[] = array('product'=>$parts[0].'|'.$parts[1]);
          }
          if ($out) return $out;
        }
      }
    }
    // top-level array of strings
    if (!$out && isset($payload[0]) && is_string($payload[0])) {
      foreach ($payload as $ln) {
        $ln = trim((string)$ln);
        if ($ln === '') continue;
        $ln = str_replace(':','|',$ln);
        $ln = preg_replace('/\s+/', '', $ln);
        $parts = explode('|',$ln);
        if (count($parts) >= 2) $out[] = array('product'=>$parts[0].'|'.$parts[1]);
      }
      if ($out) return $out;
    }
  }

  // C) Plain text (one account per line)
  if (is_string($payload) && trim($payload) !== '') {
    $lines = preg_split('/[\r\n,]+/', trim($payload));
    foreach ($lines as $ln) {
      $ln = trim($ln);
      if ($ln === '') continue;
      $ln = str_replace(':','|',$ln);
      $ln = preg_replace('/\s+/', '', $ln);
      $parts = explode('|',$ln);
      if (count($parts) >= 2) $out[] = array('product'=>$parts[0].'|'.$parts[1]);
    }
  }

  return $out;
}

// Try JSON first
$r1  = spt_buy($collectionId, $quantity, 'json');
$out = parse_accounts($r1['json'] ?? $r1['raw']);

// Fallback to text
if (!$out) {
  $r2  = spt_buy($collectionId, $quantity, 'text');
  $out = parse_accounts($r2['json'] ?? $r2['raw']);
}

// Log if empty (PHP 7.2-safe)
if (!$out) {
  $logDir = storage_path('buy_logs');
  @mkdir($logDir, 0775, true);

  $logText  = "URL1: ".$r1['url']."\nCT1: ".$r1['ctype']."\nRAW1:\n".substr((string)($r1['raw'] ?? ''),0,4000);
  if (isset($r2)) {
    $logText .= "\n\nURL2: ".($r2['url'] ?? '')."\nCT2: ".($r2['ctype'] ?? '')."\nRAW2:\n".substr((string)($r2['raw'] ?? ''),0,4000);
  }
  @file_put_contents(
    $logDir.'/'.preg_replace('/[^a-zA-Z0-9_\-]/','_', $order_id).'.log',
    $logText
  );

  if ($debug) {
    json_out(array(
      'error'=>'purchase_failed_or_empty',
      'hint' =>'see storage/buy_logs/'.$order_id.'.log'
    ), 502);
  }
  json_out(array('error'=>'purchase_failed_or_empty'), 502);
}

// Save idempotent & return
$orders[$order_id] = $out;
write_json_file($ordersPath, $orders);
json_out($out);
