<?php
declare(strict_types=1);
function cors_and_preflight(): void {
  header('Access-Control-Allow-Origin: ' . CORS_ORIGIN);
  header('Vary: Origin');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  header('Access-Control-Allow-Headers: Content-Type, Authorization, X-TPH-Key');
  if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
}
function json_out(array $data, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  echo json_encode($data, JSON_UNESCAPED_UNICODE);
  exit;
}
function storage_path(string $name): string { return __DIR__ . '/../storage/' . $name; }
function read_json_file(string $path) {
  if (!is_file($path)) return null;
  $txt = @file_get_contents($path);
  if ($txt === false) return null;
  $j = json_decode($txt, true);
  return is_array($j) ? $j : null;
}
function write_json_file(string $path, $data): bool {
  $dir = dirname($path);
  if (!is_dir($dir)) @mkdir($dir, 0775, true);
  $tmp = $path . '.tmp';
  $ok = @file_put_contents($tmp, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
  if ($ok === false) return false;
  return @rename($tmp, $path);
}
function load_extra_keys(): array {
  if (!defined('ENABLE_KEYS_JSON') || !ENABLE_KEYS_JSON) return ['global'=>[], 'type'=>[]];
  $j = read_json_file(storage_path('keys.json'));
  if (!is_array($j)) return ['global'=>[], 'type'=>[]];
  return [
    'global' => isset($j['global']) && is_array($j['global']) ? $j['global'] : [],
    'type'   => isset($j['type'])   && is_array($j['type'])   ? $j['type']   : [],
  ];
}
function require_key(?string $type = null): string {
  $given = trim((string)($_GET['key'] ?? $_SERVER['HTTP_X_TPH_KEY'] ?? ''));
  if ($given === '' && ALLOW_NO_KEY) return '';
  $allowed = [];
  if ($type && defined('TPH_KEYS_BY_TYPE') && isset(TPH_KEYS_BY_TYPE[$type])) {
    $allowed = array_merge($allowed, TPH_KEYS_BY_TYPE[$type]);
  }
  $extra = load_extra_keys();
  $allowed = array_merge($allowed, $extra['global']);
  if ($type && isset($extra['type'][$type]) && is_array($extra['type'][$type])) {
    $allowed = array_merge($allowed, $extra['type'][$type]);
  }
  $allowed = array_values(array_unique(array_map('strval', array_filter($allowed, fn($x)=>trim((string)$x) !== ''))));
  foreach ($allowed as $k) { if (hash_equals((string)$k, $given)) return $given; }
  json_out(['error'=>'unauthorized'], 401);
}
function http_get_json(string $url, int $timeout = 15) {
  if (!function_exists('curl_init')) return null;
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_TIMEOUT        => $timeout,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => 0,
    CURLOPT_HTTPHEADER     => ['Accept: application/json'],
    CURLOPT_USERAGENT      => 'Taphoammo-Proxy/3.0',
    CURLOPT_IPRESOLVE      => CURL_IPRESOLVE_V4,
  ]);
  $body = curl_exec($ch);
  $err  = curl_error($ch);
  curl_close($ch);
  if ($body === false || $err) return null;
  $j = json_decode($body, true);
  return is_array($j) ? $j : null;
}
